;  DES encryption routines
;  written by alexander yaworsky
;  '99

.386
.MODEL FLAT

DESDATA      STRUC
Key          DB    8 DUP (?)
Iterations   DD    ?
ModeCBC      DD    ?
Keys         DB    128 DUP (?)         ;    ⮫쪮 6  ⮢
CBC_Block    DB    8 DUP (?)
CBC_Block_A  DB    8 DUP (?)
First_CBC_Action DD ?
Last_CBC_Action  DD ?
KeyIndex     DD    ?
AddValue     DD    ?
Pointer      DD    ?
ByteCount    DD    ?
Counter      DB    ?
DESDATA      ENDS

; Byte order is always LSB !

MoveBit      MACRO Src,Bit,Dst         ; Basic step in bit swap procedures
             bt    Src,Bit
             rcr   Dst,1
             ENDM

.DATA?
.DATA

m_LS         DB    1,2,2,2,2,2,2,1,2,2,2,2,2,2,1,1  ;  -᫥
; UBYTE _PC_2[]={ 13,16,10,23, 0, 4,
;                  2,27,14, 5,20, 9,
;                 22,18,11, 3,25, 7,
;                 15, 6,26,19,12, 1,
;                 40,51,30,36,46,54,
;                 29,39,50,44,32,47,
;                 43,48,38,55,33,52,
;                 45,41,49,35,28,31  };
; UBYTE _IP[]={ 57,49,41,33,25,17, 9, 1,
;               59,51,43,35,27,19,11, 3,
;               61,53,45,37,29,21,13, 5,
;               63,55,47,39,31,23,15, 7,
;               56,48,40,32,24,16, 8, 0,
;               58,50,42,34,26,18,10, 2,
;               60,52,44,36,28,20,12, 4,
;               62,54,46,38,30,22,14, 6  };
; UBYTE _IP_1[]={ 39, 7,47,15,55,23,63,31,
;                 38, 6,46,14,54,22,62,30,
;                 37, 5,45,13,53,21,61,29,
;                 36, 4,44,12,52,20,60,28,
;                 35, 3,43,11,51,19,59,27,
;                 34, 2,42,10,50,18,58,26,
;                 33, 1,41, 9,49,17,57,25,
;                 32, 0,40, 8,48,16,56,24  };
; UBYTE _E[]={ 31, 0, 1, 2, 3, 4,
;               3, 4, 5, 6, 7, 8,
;               7, 8, 9,10,11,12,
;              11,12,13,14,15,16,
;              15,16,17,18,19,20,
;              19,20,21,22,23,24,
;              23,24,25,26,27,28,
;              27,28,29,30,31, 0  };
; UBYTE _P[]={ 15, 6,19,20,
;              28,11,27,16,
;               0,14,22,25,
;               4,17,30, 9,
;               1, 7,23,13,
;              31,26, 2, 8,
;              18,12,29, 5,
;              21,10, 3,24  };

;   ⮩  㬭  16  ᪮७ ⠢ 
;    ⠢

m_S1   DB    14, 0, 4,15,13, 7, 1, 4, 2,14,15, 2,11,13, 8, 1
       DB     3,10,10, 6, 6,12,12,11, 5, 9, 9, 5, 0, 3, 7, 8
       DB     4,15, 1,12,14, 8, 8, 2,13, 4, 6, 9, 2, 1,11, 7
       DB    15, 5,12,11, 9, 3, 7,14, 3,10,10, 0, 5, 6, 0,13

m_S2   DB    240, 48, 16,208,128, 64,224,112, 96,240,176, 32, 48,128, 64,224
       DB    144,192,112,  0, 32, 16,208,160,192, 96,  0,144, 80,176, 60, 80
       DB      0,208,224,128,112,160,176, 16,160, 48, 64,240,208, 64, 16, 32
       DB     80,176,128, 96,192,112, 96,192,144,  0, 48, 80, 32,224,240,144

m_S3   DB    10,13, 0, 7, 9, 0,14, 9, 6, 3, 3, 4,15, 6, 5,10
       DB     1, 2,13, 8,12, 5, 7,14,11,12, 4,11, 2,15, 8, 1
       DB    13, 1, 6,10, 4,13, 9, 0, 8, 6,15, 9, 3, 8, 0, 7
       DB    11, 4, 1,15, 2,14,12, 3, 5,11,10, 5,14, 2, 7,12

m_S4   DB    112,208,208,128,224,176, 48, 80,  0, 96, 96,240,144,  0,160, 48
       DB     16, 64, 32,112,128, 32, 80,192,176, 16,192,160, 64,224,240,144
       DB    160, 48, 96,240,144,  0,  0, 96,192,160,176, 16,112,208,208,128
       DB    240,144, 16, 64, 48, 80,224,176, 80,192, 32,112,128, 32, 64,224

m_S5   DB     2,14,12,11, 4, 2, 1,12, 7, 4,10, 7,11,13, 6, 1
       DB     8, 5, 5, 0, 3,15,15,10,13, 3, 0, 9,14, 8, 9, 6
       DB     4,11, 2, 8, 1,12,11, 7,10, 1,13,14, 7, 2, 8,13
       DB    15, 6, 9,15,12, 0, 5, 9, 6,10, 3, 4, 0, 5,14, 3

m_S6   DB    192,160, 16,240,160, 64,240, 32,144,112, 32,192, 96,144,128, 80
       DB      0, 96,208, 16, 48,208, 64,224,224,  0,112,176, 80, 48,176,128
       DB    144, 64,224, 48,240, 32, 80,192, 32,144,128, 80,192,240, 48,160
       DB    112,176,  0,224, 64, 16,160,112, 16, 96,208,  0,176,128, 96,208

m_S7   DB     4,13,11, 0, 2,11,14, 7,15, 4, 0, 9, 8, 1,13,10
       DB     3,14,12, 3, 9, 5, 7,12, 5, 2,10,15, 6, 8, 1, 6
       DB     1, 6, 4,11,11,13,13, 8,12, 1, 3, 4, 7,10,14, 7
       DB    10, 9,15, 5, 6, 0, 8,15, 0,14, 5, 2, 9, 3, 2,12

m_S8   DB    208, 16, 32,240,128,208, 64,128, 96,160,240, 48,176,112, 16, 64
       DB    160,192,144, 80, 48, 96,224,176, 80,  0,  0,224,192,144,112, 32
       DB    112, 32,176, 16, 64,224, 16,112,144, 64,192,160,224,128, 32,208
       DB      0,240, 96,192,160,144,208,  0,240, 48, 48, 80, 80, 96,128,176



.CODE

DesInit      PROC
             PUBLIC DesInit
             push  EBP
             mov   EBP,ESP
             push  EBX
             push  ESI
             push  EDI

             mov   EBX,[EBP+8]
             or    EBX,EBX
             jz    diCnt1
             mov   EAX,DWORD PTR Key[EBX]        ; C
             mov   EDX,DWORD PTR Key[EBX + 4]    ; D
             mov   DWORD PTR CBC_Block[EBX],EAX
             mov   DWORD PTR CBC_Block[EBX + 4],EDX
             mov   ESI,16
             lea   EDI,Keys[EBX]
diLp0:
;
; 1) Rotate left C and D
;
             mov   CL,m_LS[ESI-1]
diLp1:
             shl   EDX,1               ; rotate left D
             bt    EDX,28
             adc   DL,0

             shl   EAX,1               ; rotate left D
             bt    EAX,28
             adc   AL,0

             dec   CL
             jnz   diLp1
;
; 2) Swap bits: EDX:EAX -> ECX(8,6,4,2):EBP(7,5,3,1) according to PC-2
;
             MoveBit EAX, 13, EBP
             MoveBit EAX, 16, EBP
             MoveBit EAX, 10, EBP
             MoveBit EAX, 23, EBP
             MoveBit EAX,  0, EBP
             MoveBit EAX,  4, EBP
             shr   EBP,2
             MoveBit EAX,  2, ECX
             MoveBit EAX, 27, ECX
             MoveBit EAX, 14, ECX
             MoveBit EAX,  5, ECX
             MoveBit EAX, 20, ECX
             MoveBit EAX,  9, ECX
             shr   ECX,2
             MoveBit EAX, 22, EBP
             MoveBit EAX, 18, EBP
             MoveBit EAX, 11, EBP
             MoveBit EAX,  3, EBP
             MoveBit EAX, 25, EBP
             MoveBit EAX,  7, EBP
             shr   EBP,2
             MoveBit EAX, 15, ECX
             MoveBit EAX,  6, ECX
             MoveBit EAX, 26, ECX
             MoveBit EAX, 19, ECX
             MoveBit EAX, 12, ECX
             MoveBit EAX,  1, ECX
             shr   ECX,2

             MoveBit EDX, 40-28, EBP
             MoveBit EDX, 51-28, EBP
             MoveBit EDX, 30-28, EBP
             MoveBit EDX, 36-28, EBP
             MoveBit EDX, 46-28, EBP
             MoveBit EDX, 54-28, EBP
             shr   EBP,2
             MoveBit EDX, 29-28, ECX
             MoveBit EDX, 39-28, ECX
             MoveBit EDX, 50-28, ECX
             MoveBit EDX, 44-28, ECX
             MoveBit EDX, 32-28, ECX
             MoveBit EDX, 47-28, ECX
             shr   ECX,2
             MoveBit EDX, 43-28, EBP
             MoveBit EDX, 48-28, EBP
             MoveBit EDX, 38-28, EBP
             MoveBit EDX, 55-28, EBP
             MoveBit EDX, 33-28, EBP
             MoveBit EDX, 52-28, EBP
             shr   EBP,2
             MoveBit EDX, 45-28, ECX
             MoveBit EDX, 41-28, ECX
             MoveBit EDX, 49-28, ECX
             MoveBit EDX, 35-28, ECX
             MoveBit EDX, 28-28, ECX
             MoveBit EDX, 31-28, ECX
             shr   ECX,2

             mov   DWORD PTR [EDI],EBP
             mov   DWORD PTR [EDI+4],ECX
             add   EDI,8
             dec   ESI
             jnz   diLp0

             cmp   Iterations[EBX],16
             jna   SHORT diCnt0
             mov   Iterations[EBX],16
diCnt0:
             cmp   Iterations[EBX],0
             ja    SHORT diCnt1
             mov   Iterations[EBX],16
diCnt1:
             pop   EDI
             pop   ESI
             pop   EBX
             pop   EBP
             ret
DesInit      ENDP


Encr_CBC_First PROC NEAR
             xor   EAX,DWORD PTR CBC_Block[ESI]
             xor   EDX,DWORD PTR CBC_Block[ESI+4]
             ret
Encr_CBC_First ENDP

Encr_CBC_Last PROC NEAR
             mov   DWORD PTR CBC_Block[ESI],EAX
             mov   DWORD PTR CBC_Block[ESI+4],EDX
             ret
Encr_CBC_Last ENDP

Decr_CBC_First PROC NEAR
             mov   DWORD PTR CBC_Block_A[ESI],EAX
             mov   DWORD PTR CBC_Block_A[ESI+4],EDX
             ret
Decr_CBC_First ENDP

Decr_CBC_Last PROC NEAR
             xor   EAX,DWORD PTR CBC_Block[ESI]
             xor   EDX,DWORD PTR CBC_Block[ESI+4]
             mov   ECX,DWORD PTR CBC_Block_A[ESI]
             mov   DWORD PTR CBC_Block[ESI],ECX
             mov   ECX,DWORD PTR CBC_Block_A[ESI+4]
             mov   DWORD PTR CBC_Block[ESI+4],ECX
Dummy:
             ret
Decr_CBC_Last ENDP



dcGetTail:   mov   ECX,ByteCount[ESI]
             mov   AL,3Ch
dcgt0:
             xor   BYTE PTR [EDI],AL
             inc   EDI
             rol   AL,1
             loop  dcgt0
             jmp   dcStop


DesCrypt     PROC
             PUBLIC DesCrypt
             push  EBP
             mov   EBP,ESP
             push  EBX
             push  ESI
             push  EDI

             mov   ESI,[EBP+8]         ; pointer to DESDATA
             mov   EDI,[EBP+12]        ; pointer to block
             mov   EDX,[EBP+16]        ; counter
             or    EDX,EDX
             jz    dcStop
             or    ESI,ESI
             jz    dcStop
             mov   EAX,First_CBC_Action[ESI]
             cmp   EAX,offset Dummy
             jz    SHORT dcCnt00
             cmp   EAX,offset Encr_CBC_First
             jz    SHORT dcCnt00
             cmp   EAX,offset Decr_CBC_First
             jnz   dcStop
dcCnt00:
             mov   EAX,Last_CBC_Action[ESI]
             cmp   EAX,offset Dummy
             jz    SHORT dcCnt01
             cmp   EAX,offset Encr_CBC_Last
             jz    SHORT dcCnt01
             cmp   EAX,offset Decr_CBC_Last
             jnz   dcStop
dcCnt01:
             mov   ByteCount[ESI],EDX
dcLp0:
             mov   Pointer[ESI],EDI
             cmp   ByteCount[ESI],0
             jz    dcStop
             cmp   ByteCount[ESI],8
             jb    dcGetTail
             mov   EAX,[EDI]
             mov   EDX,[EDI+4]
dcCnt0:
             call  First_CBC_Action[ESI]
;
; 1) IP swap EDX:EAX to ECX:EBP: if bit number < 32 src is EAX else EDX
;
             MoveBit EDX, 57-32, EBP
             MoveBit EDX, 49-32, EBP
             MoveBit EDX, 41-32, EBP
             MoveBit EDX, 33-32, EBP
             MoveBit EAX, 25, EBP
             MoveBit EAX, 17, EBP
             MoveBit EAX,  9, EBP
             MoveBit EAX,  1, EBP
             MoveBit EDX, 59-32, EBP
             MoveBit EDX, 51-32, EBP
             MoveBit EDX, 43-32, EBP
             MoveBit EDX, 35-32, EBP
             MoveBit EAX, 27, EBP
             MoveBit EAX, 19, EBP
             MoveBit EAX, 11, EBP
             MoveBit EAX,  3, EBP
             MoveBit EDX, 61-32, EBP
             MoveBit EDX, 53-32, EBP
             MoveBit EDX, 45-32, EBP
             MoveBit EDX, 37-32, EBP
             MoveBit EAX, 29, EBP
             MoveBit EAX, 21, EBP
             MoveBit EAX, 13, EBP
             MoveBit EAX,  5, EBP
             MoveBit EDX, 63-32, EBP
             MoveBit EDX, 55-32, EBP
             MoveBit EDX, 47-32, EBP
             MoveBit EDX, 39-32, EBP
             MoveBit EAX, 31, EBP
             MoveBit EAX, 23, EBP
             MoveBit EAX, 15, EBP
             MoveBit EAX,  7, EBP
             MoveBit EDX, 56-32, ECX
             MoveBit EDX, 48-32, ECX
             MoveBit EDX, 40-32, ECX
             MoveBit EDX, 32-32, ECX
             MoveBit EAX, 24, ECX
             MoveBit EAX, 16, ECX
             MoveBit EAX,  8, ECX
             MoveBit EAX,  0, ECX
             MoveBit EDX, 58-32, ECX
             MoveBit EDX, 50-32, ECX
             MoveBit EDX, 42-32, ECX
             MoveBit EDX, 34-32, ECX
             MoveBit EAX, 26, ECX
             MoveBit EAX, 18, ECX
             MoveBit EAX, 10, ECX
             MoveBit EAX,  2, ECX
             MoveBit EDX, 60-32, ECX
             MoveBit EDX, 52-32, ECX
             MoveBit EDX, 44-32, ECX
             MoveBit EDX, 36-32, ECX
             MoveBit EAX, 28, ECX
             MoveBit EAX, 20, ECX
             MoveBit EAX, 12, ECX
             MoveBit EAX,  4, ECX
             MoveBit EDX, 62-32, ECX
             MoveBit EDX, 54-32, ECX
             MoveBit EDX, 46-32, ECX
             MoveBit EDX, 38-32, ECX
             MoveBit EAX, 30, ECX
             MoveBit EAX, 22, ECX
             MoveBit EAX, 14, ECX
             MoveBit EAX,  6, ECX

             mov   EDI,KeyIndex[ESI]
             mov   EAX,Iterations[ESI]
             mov   Counter[ESI],AL
dcLp1:
;
; 2) Compute F-function
;
; 2.1) Extend R-block EBP to EDX(8,6,4,2):EAX(7,5,3,1) according to E
;
             mov   EDX,EBP
             mov   EAX,EBP
             rol   EAX,1
             ror   EDX,3
             and   EAX,3F3F3F3Fh
             and   EDX,3F3F3F3Fh
;
; 2.2) XOR extended block EDX:EAX with key[n] and use m_S -> EAX(2,1,4,3)
;
             xor   EAX,DWORD PTR Keys[ESI][EDI]
             xor   EDX,DWORD PTR Keys[ESI][EDI+4]
             add   EDI,AddValue[ESI]

             xor   EBX,EBX
             mov   BL,AL
             mov   AL,m_S1[EBX]
             mov   BL,DL
             add   AL,m_S2[EBX]
             mov   BL,AH
             mov   AH,m_S3[EBX]
             mov   BL,DH
             add   AH,m_S4[EBX]

             shrd  EDX,EAX,16
             ror   EAX,16
             mov   BL,AL
             mov   AL,m_S5[EBX]
             mov   BL,DL
             add   AL,m_S6[EBX]
             mov   BL,AH
             mov   AH,m_S7[EBX]
             mov   BL,DH
             add   AH,m_S8[EBX]
;
; 2.3) Swap bits EAX->EDX according to P
;
             MoveBit EAX, 15+16, EDX
             MoveBit EAX,  6+16, EDX
             MoveBit EAX, 19-16, EDX
             MoveBit EAX, 20-16, EDX
             MoveBit EAX, 28-16, EDX
             MoveBit EAX, 11+16, EDX
             MoveBit EAX, 27-16, EDX
             MoveBit EAX, 16-16, EDX
             MoveBit EAX,  0+16, EDX
             MoveBit EAX, 14+16, EDX
             MoveBit EAX, 22-16, EDX
             MoveBit EAX, 25-16, EDX
             MoveBit EAX,  4+16, EDX
             MoveBit EAX, 17-16, EDX
             MoveBit EAX, 30-16, EDX
             MoveBit EAX,  9+16, EDX
             MoveBit EAX,  1+16, EDX
             MoveBit EAX,  7+16, EDX
             MoveBit EAX, 23-16, EDX
             MoveBit EAX, 13+16, EDX
             MoveBit EAX, 31-16, EDX
             MoveBit EAX, 26-16, EDX
             MoveBit EAX,  2+16, EDX
             MoveBit EAX,  8+16, EDX
             MoveBit EAX, 18-16, EDX
             MoveBit EAX, 12+16, EDX
             MoveBit EAX, 29-16, EDX
             MoveBit EAX,  5+16, EDX
             MoveBit EAX, 21-16, EDX
             MoveBit EAX, 10+16, EDX
             MoveBit EAX,  3+16, EDX
             MoveBit EAX, 24-16, EDX
;
; 3) XOR F-function (EDX) with L-block (ECX) and swap L and R blocks
;
             xor   ECX,EDX
             xchg  ECX,EBP
             dec   Counter[ESI]
             jnz   dcLp1
             xchg  ECX,EBP
;
; 4) IP-1 swap ECX:EBP -> EDX:EAX: if bit number < 32 src is EBP else ECX
;
             MoveBit ECX, 39-32, EAX
             MoveBit EBP,  7, EAX
             MoveBit ECX, 47-32, EAX
             MoveBit EBP, 15, EAX
             MoveBit ECX, 55-32, EAX
             MoveBit EBP, 23, EAX
             MoveBit ECX, 63-32, EAX
             MoveBit EBP, 31, EAX
             MoveBit ECX, 38-32, EAX
             MoveBit EBP,  6, EAX
             MoveBit ECX, 46-32, EAX
             MoveBit EBP, 14, EAX
             MoveBit ECX, 54-32, EAX
             MoveBit EBP, 22, EAX
             MoveBit ECX, 62-32, EAX
             MoveBit EBP, 30, EAX
             MoveBit ECX, 37-32, EAX
             MoveBit EBP,  5, EAX
             MoveBit ECX, 45-32, EAX
             MoveBit EBP, 13, EAX
             MoveBit ECX, 53-32, EAX
             MoveBit EBP, 21, EAX
             MoveBit ECX, 61-32, EAX
             MoveBit EBP, 29, EAX
             MoveBit ECX, 36-32, EAX
             MoveBit EBP,  4, EAX
             MoveBit ECX, 44-32, EAX
             MoveBit EBP, 12, EAX
             MoveBit ECX, 52-32, EAX
             MoveBit EBP, 20, EAX
             MoveBit ECX, 60-32, EAX
             MoveBit EBP, 28, EAX

             MoveBit ECX, 35-32, EDX
             MoveBit EBP,  3, EDX
             MoveBit ECX, 43-32, EDX
             MoveBit EBP, 11, EDX
             MoveBit ECX, 51-32, EDX
             MoveBit EBP, 19, EDX
             MoveBit ECX, 59-32, EDX
             MoveBit EBP, 27, EDX
             MoveBit ECX, 34-32, EDX
             MoveBit EBP,  2, EDX
             MoveBit ECX, 42-32, EDX
             MoveBit EBP, 10, EDX
             MoveBit ECX, 50-32, EDX
             MoveBit EBP, 18, EDX
             MoveBit ECX, 58-32, EDX
             MoveBit EBP, 26, EDX
             MoveBit ECX, 33-32, EDX
             MoveBit EBP,  1, EDX
             MoveBit ECX, 41-32, EDX
             MoveBit EBP,  9, EDX
             MoveBit ECX, 49-32, EDX
             MoveBit EBP, 17, EDX
             MoveBit ECX, 57-32, EDX
             MoveBit EBP, 25, EDX
             MoveBit ECX, 32-32, EDX
             MoveBit EBP,  0, EDX
             MoveBit ECX, 40-32, EDX
             MoveBit EBP,  8, EDX
             MoveBit ECX, 48-32, EDX
             MoveBit EBP, 16, EDX
             MoveBit ECX, 56-32, EDX
             MoveBit EBP, 24, EDX

             call  Last_CBC_Action[ESI]
             mov   EDI,Pointer[ESI]
             mov   [EDI],EAX
             mov   [EDI+4],EDX
             add   EDI,8
             sub   ByteCount[ESI],8
             ja    dcLp0
dcStop:
             pop   EDI
             pop   ESI
             pop   EBX
             pop   EBP
             ret
DesCrypt     ENDP



DesEncrypt   PROC
             PUBLIC DesEncrypt
             push  EBP
             mov   EBP,ESP
             push  EBX
             mov   EBX,[EBP+8]
             or    EBX,EBX
             jz    SHORT deStop
             mov   KeyIndex[EBX], 0
             mov   First_CBC_Action[EBX], offset Dummy
             mov   Last_CBC_Action[EBX], offset Dummy
             cmp   ModeCBC[EBX],0
             jz    SHORT deCnt0
             mov   First_CBC_Action[EBX], offset Encr_CBC_First
             mov   Last_CBC_Action[EBX], offset Encr_CBC_Last
deCnt0:
             mov   AddValue[EBX],8
             mov   EAX,5A5A5A5Ah
             mov   DWORD PTR CBC_Block[EBX],EAX
             mov   DWORD PTR CBC_Block[EBX+4],EAX
deStop:
             pop   EBX
             pop   EBP
             ret
DesEncrypt   ENDP


DesDecrypt   PROC
             PUBLIC DesDecrypt
             push  EBP
             mov   EBP,ESP
             push  EBX
             mov   EBX,[EBP+8]
             or    EBX,EBX
             jz    SHORT ddStop
             mov   EAX,Iterations[EBX]
             dec   EAX
             shl   EAX,3
             mov   KeyIndex[EBX],EAX
             mov   First_CBC_Action[EBX], offset Dummy
             mov   Last_CBC_Action[EBX], offset Dummy
             cmp   ModeCBC[EBX],0
             jz    SHORT ddCnt0
             mov   First_CBC_Action[EBX], offset Decr_CBC_First
             mov   Last_CBC_Action[EBX], offset Decr_CBC_Last
ddCnt0:
             mov   AddValue[EBX],-8
             mov   EAX,5A5A5A5Ah
             mov   DWORD PTR CBC_Block[EBX],EAX
             mov   DWORD PTR CBC_Block[EBX+4],EAX
ddStop:
             pop   EBX
             pop   EBP
             ret
DesDecrypt   ENDP
             END
